/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import javax.crypto.BadPaddingException;
import sun.security.ssl.ContentType;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.Plaintext;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLCipher;
import sun.security.ssl.TransportContext;

abstract class InputRecord
implements Record,
Closeable {
    SSLCipher.SSLReadCipher readCipher;
    TransportContext tc;
    final HandshakeHash handshakeHash;
    boolean isClosed;
    ProtocolVersion helloVersion;
    int fragmentSize;

    InputRecord(HandshakeHash handshakeHash, SSLCipher.SSLReadCipher sSLReadCipher) {
        this.readCipher = sSLReadCipher;
        this.helloVersion = ProtocolVersion.TLS10;
        this.handshakeHash = handshakeHash;
        this.isClosed = false;
        this.fragmentSize = 16384;
    }

    void setHelloVersion(ProtocolVersion protocolVersion) {
        this.helloVersion = protocolVersion;
    }

    boolean seqNumIsHuge() {
        return this.readCipher.authenticator != null && this.readCipher.authenticator.seqNumIsHuge();
    }

    boolean isEmpty() {
        return false;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            this.readCipher.dispose();
        }
    }

    synchronized boolean isClosed() {
        return this.isClosed;
    }

    void changeReadCiphers(SSLCipher.SSLReadCipher sSLReadCipher) {
        sSLReadCipher.dispose();
        this.readCipher = sSLReadCipher;
    }

    void changeFragmentSize(int n) {
        this.fragmentSize = n;
    }

    int bytesInCompletePacket(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    int bytesInCompletePacket() throws IOException {
        throw new UnsupportedOperationException();
    }

    void setReceiverStream(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    abstract Plaintext[] decode(ByteBuffer[] var1, int var2, int var3) throws IOException, BadPaddingException;

    void setDeliverStream(OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    int estimateFragmentSize(int n) {
        throw new UnsupportedOperationException();
    }

    static ByteBuffer convertToClientHello(ByteBuffer byteBuffer) {
        int n;
        int n2;
        int n3 = byteBuffer.position();
        byte by = byteBuffer.get();
        byte by2 = byteBuffer.get();
        int n4 = ((by & 0x7F) << 8 | by2 & 0xFF) + 2;
        byteBuffer.position(n3 + 3);
        byte by3 = byteBuffer.get();
        byte by4 = byteBuffer.get();
        int n5 = ((byteBuffer.get() & 0xFF) << 8) + (byteBuffer.get() & 0xFF);
        int n6 = ((byteBuffer.get() & 0xFF) << 8) + (byteBuffer.get() & 0xFF);
        int n7 = ((byteBuffer.get() & 0xFF) << 8) + (byteBuffer.get() & 0xFF);
        int n8 = 48 + n6 + n5 * 2 / 3;
        byte[] byArray = new byte[n8];
        byArray[0] = ContentType.HANDSHAKE.id;
        byArray[1] = by3;
        byArray[2] = by4;
        byArray[5] = 1;
        byArray[9] = by3;
        byArray[10] = by4;
        int n9 = 11;
        int n10 = n3 + 11 + n5 + n6;
        if (n7 < 32) {
            for (n2 = 0; n2 < 32 - n7; ++n2) {
                byArray[n9++] = 0;
            }
            byteBuffer.position(n10);
            byteBuffer.get(byArray, n9, n7);
            n9 += n7;
        } else {
            byteBuffer.position(n10 + n7 - 32);
            byteBuffer.get(byArray, n9, 32);
            n9 += 32;
        }
        byArray[n9++] = (byte)(n6 & 0xFF);
        byteBuffer.position(n10 -= n6);
        byteBuffer.get(byArray, n9, n6);
        byteBuffer.position(n10 -= n5);
        n2 = n9 + 2;
        for (n = 0; n < n5; n += 3) {
            if (byteBuffer.get() != 0) {
                byteBuffer.get();
                byteBuffer.get();
                continue;
            }
            byArray[n2++] = byteBuffer.get();
            byArray[n2++] = byteBuffer.get();
        }
        n2 -= n9 + 2;
        byArray[n9++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n9++] = (byte)(n2 & 0xFF);
        n9 += n2;
        byArray[n9++] = 1;
        byArray[n9++] = 0;
        n = n9 - 5;
        byArray[3] = (byte)(n >>> 8 & 0xFF);
        byArray[4] = (byte)(n & 0xFF);
        n = n9 - 9;
        byArray[6] = (byte)(n >>> 16 & 0xFF);
        byArray[7] = (byte)(n >>> 8 & 0xFF);
        byArray[8] = (byte)(n & 0xFF);
        byteBuffer.position(n3 + n4);
        return ByteBuffer.wrap(byArray, 5, n9 - 5);
    }

    static ByteBuffer extract(ByteBuffer[] byteBufferArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl = false;
        int n9 = -1;
        int n10 = 0;
        block0: for (n8 = n; n8 < n + n2 && n10 < n3; ++n8) {
            n7 = byteBufferArray[n8].remaining();
            n6 = byteBufferArray[n8].position();
            for (n5 = 0; n5 < n7 && n10 < n3; ++n10, ++n5) {
                n4 = byteBufferArray[n8].get(n6 + n5);
                if (n10 == n3 - 2) {
                    n9 = (n4 & 0xFF) << 8;
                    continue;
                }
                if (n10 != n3 - 1) continue;
                n9 |= n4 & 0xFF;
                bl = true;
                continue block0;
            }
        }
        if (!bl) {
            throw new BufferUnderflowException();
        }
        n8 = n3 + n9;
        n10 = 0;
        for (n7 = n; n7 < n + n2 && (n10 += byteBufferArray[n7].remaining()) < n8; ++n7) {
        }
        if (n10 < n8) {
            throw new BufferUnderflowException();
        }
        byte[] byArray = new byte[n8];
        n6 = 0;
        n5 = n8;
        for (n4 = n; n4 < n + n2; ++n4) {
            if (byteBufferArray[n4].hasRemaining()) {
                int n11 = Math.min(n5, byteBufferArray[n4].remaining());
                byteBufferArray[n4].get(byArray, n6, n11);
                n6 += n11;
                n5 -= n11;
            }
            if (n5 <= 0) break;
        }
        return ByteBuffer.wrap(byArray);
    }
}

