/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Objects;
import javax.xml.transform.SourceLocator;

public class TransformerException
extends Exception {
    private static final long serialVersionUID = 975798773772956428L;
    SourceLocator locator;
    Throwable containedException;

    public SourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(SourceLocator sourceLocator) {
        this.locator = sourceLocator;
    }

    public Throwable getException() {
        return this.containedException;
    }

    @Override
    public Throwable getCause() {
        return this.containedException == this ? null : this.containedException;
    }

    @Override
    public synchronized Throwable initCause(Throwable throwable) {
        if (this.containedException != null) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (throwable == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.containedException = throwable;
        return this;
    }

    public TransformerException(String string) {
        this(string, null, null);
    }

    public TransformerException(Throwable throwable) {
        this(null, null, throwable);
    }

    public TransformerException(String string, Throwable throwable) {
        this(string, null, throwable);
    }

    public TransformerException(String string, SourceLocator sourceLocator) {
        this(string, sourceLocator, null);
    }

    public TransformerException(String string, SourceLocator sourceLocator, Throwable throwable) {
        super(string == null || string.length() == 0 ? (throwable == null ? "" : throwable.toString()) : string);
        this.containedException = throwable;
        this.locator = sourceLocator;
    }

    public String getMessageAndLocation() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Objects.toString(super.getMessage(), ""));
        stringBuilder.append(Objects.toString(this.getLocationAsString(), ""));
        return stringBuilder.toString();
    }

    public String getLocationAsString() {
        if (this.locator == null) {
            return null;
        }
        if (System.getSecurityManager() == null) {
            return this.getLocationString();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return TransformerException.this.getLocationString();
            }
        }, new AccessControlContext(new ProtectionDomain[]{this.getNonPrivDomain()}));
    }

    private String getLocationString() {
        if (this.locator == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.locator.getSystemId();
        int n = this.locator.getLineNumber();
        int n2 = this.locator.getColumnNumber();
        if (null != string) {
            stringBuilder.append("; SystemID: ");
            stringBuilder.append(string);
        }
        if (0 != n) {
            stringBuilder.append("; Line#: ");
            stringBuilder.append(n);
        }
        if (0 != n2) {
            stringBuilder.append("; Column#: ");
            stringBuilder.append(n2);
        }
        return stringBuilder.toString();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(new PrintWriter(System.err, true));
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(printStream));
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        Object object;
        if (printWriter == null) {
            printWriter = new PrintWriter(System.err, true);
        }
        try {
            object = this.getLocationAsString();
            if (null != object) {
                printWriter.println((String)object);
            }
            super.printStackTrace(printWriter);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = this.getException();
        for (int i = 0; i < 10 && null != object; ++i) {
            Object object2;
            printWriter.println("---------");
            try {
                if (object instanceof TransformerException && null != (object2 = ((TransformerException)object).getLocationAsString())) {
                    printWriter.println((String)object2);
                }
                ((Throwable)object).printStackTrace(printWriter);
            }
            catch (Throwable throwable) {
                printWriter.println("Could not print stack trace...");
            }
            try {
                object2 = object.getClass().getMethod("getException", null);
                if (null != object2) {
                    Object object3 = object;
                    if (object3 != (object = (Throwable)((Method)object2).invoke(object, null))) continue;
                    break;
                }
                object = null;
                continue;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                object = null;
            }
        }
        printWriter.flush();
    }

    private ProtectionDomain getNonPrivDomain() {
        CodeSource codeSource = new CodeSource(null, (CodeSigner[])null);
        Permissions permissions = new Permissions();
        return new ProtectionDomain(codeSource, permissions);
    }
}

