/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.ws.encoding.ContentType;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XmlDataContentHandler
implements DataContentHandler {
    private final DataFlavor[] flavors = new DataFlavor[3];

    public XmlDataContentHandler() throws ClassNotFoundException {
        this.flavors[0] = new ActivationDataFlavor(StreamSource.class, "text/xml", "XML");
        this.flavors[1] = new ActivationDataFlavor(StreamSource.class, "application/xml", "XML");
        this.flavors[2] = new ActivationDataFlavor(String.class, "text/xml", "XML String");
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return Arrays.copyOf(this.flavors, this.flavors.length);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws IOException {
        for (DataFlavor dataFlavor2 : this.flavors) {
            if (!dataFlavor2.equals(dataFlavor)) continue;
            return this.getContent(dataSource);
        }
        return null;
    }

    @Override
    public Object getContent(DataSource dataSource) throws IOException {
        String string = dataSource.getContentType();
        String string2 = null;
        if (string != null) {
            ContentType contentType = new ContentType(string);
            if (!this.isXml(contentType)) {
                throw new IOException("Cannot convert DataSource with content type \"" + string + "\" to object in XmlDataContentHandler");
            }
            string2 = contentType.getParameter("charset");
        }
        return string2 != null ? new StreamSource(new InputStreamReader(dataSource.getInputStream()), string2) : new StreamSource(dataSource.getInputStream());
    }

    @Override
    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        if (!(object instanceof DataSource || object instanceof Source || object instanceof String)) {
            throw new IOException("Invalid Object type = " + object.getClass() + ". XmlDataContentHandler can only convert DataSource|Source|String to XML.");
        }
        ContentType contentType = new ContentType(string);
        if (!this.isXml(contentType)) {
            throw new IOException("Invalid content type \"" + string + "\" for XmlDataContentHandler");
        }
        String string2 = contentType.getParameter("charset");
        if (object instanceof String) {
            String string3 = (String)object;
            if (string2 == null) {
                string2 = "utf-8";
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string2);
            outputStreamWriter.write(string3, 0, string3.length());
            outputStreamWriter.flush();
            return;
        }
        Source source = object instanceof DataSource ? (Source)this.getContent((DataSource)object) : (Source)object;
        try {
            Transformer transformer = XmlUtil.newTransformer();
            if (string2 != null) {
                transformer.setOutputProperty("encoding", string2);
            }
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform(source, streamResult);
        }
        catch (Exception exception) {
            throw new IOException("Unable to run the JAXP transformer in XmlDataContentHandler " + exception.getMessage());
        }
    }

    private boolean isXml(ContentType contentType) {
        return contentType.getSubType().equals("xml") && (contentType.getPrimaryType().equals("text") || contentType.getPrimaryType().equals("application"));
    }
}

