/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.resolver.helpers;

import com.sun.org.apache.xml.internal.resolver.helpers.FileURL;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class BootstrapResolver
implements EntityResolver,
URIResolver {
    public static final String xmlCatalogXSD = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.xsd";
    public static final String xmlCatalogRNG = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.rng";
    public static final String xmlCatalogPubId = "-//OASIS//DTD XML Catalogs V1.0//EN";
    public static final String xmlCatalogSysId = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd";
    public static final String xCatalogPubId = "-//DTD XCatalog//EN";
    private final Map<String, String> publicMap = new HashMap<String, String>();
    private final Map<String, String> systemMap = new HashMap<String, String>();
    private final Map<String, String> uriMap = new HashMap<String, String>();

    public BootstrapResolver() {
        URL uRL = this.getClass().getResource("/com/sun/org/apache/xml/internal/resolver/etc/catalog.dtd");
        if (uRL != null) {
            this.publicMap.put(xmlCatalogPubId, uRL.toString());
            this.systemMap.put(xmlCatalogSysId, uRL.toString());
        }
        if ((uRL = this.getClass().getResource("/com/sun/org/apache/xml/internal/resolver/etc/catalog.rng")) != null) {
            this.uriMap.put(xmlCatalogRNG, uRL.toString());
        }
        if ((uRL = this.getClass().getResource("/com/sun/org/apache/xml/internal/resolver/etc/catalog.xsd")) != null) {
            this.uriMap.put(xmlCatalogXSD, uRL.toString());
        }
        if ((uRL = this.getClass().getResource("/com/sun/org/apache/xml/internal/resolver/etc/xcatalog.dtd")) != null) {
            this.publicMap.put(xCatalogPubId, uRL.toString());
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        String string3 = null;
        if (string2 != null && this.systemMap.containsKey(string2)) {
            string3 = this.systemMap.get(string2);
        } else if (string != null && this.publicMap.containsKey(string)) {
            string3 = this.publicMap.get(string);
        }
        if (string3 != null) {
            try {
                InputSource inputSource = new InputSource(string3);
                inputSource.setPublicId(string);
                URL uRL = new URL(string3);
                InputStream inputStream = uRL.openStream();
                inputSource.setByteStream(inputStream);
                return inputSource;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Source resolve(String string, String string2) throws TransformerException {
        Object object;
        String string3 = string;
        String string4 = null;
        int n = string.indexOf("#");
        if (n >= 0) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        String string5 = null;
        if (string != null && this.uriMap.containsKey(string)) {
            string5 = this.uriMap.get(string);
        }
        if (string5 == null) {
            try {
                object = null;
                if (string2 == null) {
                    object = new URL(string3);
                    string5 = ((URL)object).toString();
                } else {
                    URL uRL = new URL(string2);
                    object = string.length() == 0 ? uRL : new URL(uRL, string3);
                    string5 = ((URL)object).toString();
                }
            }
            catch (MalformedURLException malformedURLException) {
                String string6 = this.makeAbsolute(string2);
                if (!string6.equals(string2)) {
                    return this.resolve(string, string6);
                }
                throw new TransformerException("Malformed URL " + string + "(base " + string2 + ")", malformedURLException);
            }
        }
        object = new SAXSource();
        ((SAXSource)object).setInputSource(new InputSource(string5));
        return object;
    }

    private String makeAbsolute(String string) {
        if (string == null) {
            string = "";
        }
        try {
            URL uRL = new URL(string);
            return uRL.toString();
        }
        catch (MalformedURLException malformedURLException) {
            try {
                URL uRL = FileURL.makeURL(string);
                return uRL.toString();
            }
            catch (MalformedURLException malformedURLException2) {
                return string;
            }
        }
    }
}

