/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xslt;

import com.sun.org.apache.xalan.internal.utils.ObjectFactory;
import com.sun.org.apache.xalan.internal.utils.SecuritySupport;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class EnvironmentCheck {
    public static final String ERROR = "ERROR.";
    public static final String WARNING = "WARNING.";
    public static final String ERROR_FOUND = "At least one error was found!";
    public static final String VERSION = "version.";
    public static final String FOUNDCLASSES = "foundclasses.";
    public static final String CLASS_PRESENT = "present-unknown-version";
    public static final String CLASS_NOTPRESENT = "not-present";
    public String[] jarNames = new String[]{"xalan.jar", "xalansamples.jar", "xalanj1compat.jar", "xalanservlet.jar", "serializer.jar", "xerces.jar", "xercesImpl.jar", "testxsl.jar", "crimson.jar", "lotusxsl.jar", "jaxp.jar", "parser.jar", "dom.jar", "sax.jar", "xml.jar", "xml-apis.jar", "xsltc.jar"};
    private static final Map<Long, String> JARVERSIONS;
    protected PrintWriter outWriter = new PrintWriter(System.out, true);

    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"-out".equalsIgnoreCase(stringArray[i])) continue;
            if (++i < stringArray.length) {
                try {
                    printWriter = new PrintWriter(new FileWriter(stringArray[i], true));
                }
                catch (Exception exception) {
                    System.err.println("# WARNING: -out " + stringArray[i] + " threw " + exception.toString());
                }
                continue;
            }
            System.err.println("# WARNING: -out argument should have a filename, output sent to console");
        }
        EnvironmentCheck environmentCheck = new EnvironmentCheck();
        environmentCheck.checkEnvironment(printWriter);
    }

    public boolean checkEnvironment(PrintWriter printWriter) {
        Map<String, Object> map;
        boolean bl;
        if (null != printWriter) {
            this.outWriter = printWriter;
        }
        if (bl = this.writeEnvironmentReport(map = this.getEnvironmentHash())) {
            this.logMsg("# WARNING: Potential problems found in your environment!");
            this.logMsg("#    Check any 'ERROR' items above against the Xalan FAQs");
            this.logMsg("#    to correct potential problems with your classes/jars");
            this.logMsg("#    http://xml.apache.org/xalan-j/faq.html");
            if (null != this.outWriter) {
                this.outWriter.flush();
            }
            return false;
        }
        this.logMsg("# YAHOO! Your environment seems to be OK.");
        if (null != this.outWriter) {
            this.outWriter.flush();
        }
        return true;
    }

    public Map<String, Object> getEnvironmentHash() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.checkJAXPVersion(hashMap);
        this.checkProcessorVersion(hashMap);
        this.checkParserVersion(hashMap);
        this.checkAntVersion(hashMap);
        if (!this.checkDOML3(hashMap)) {
            this.checkDOMVersion(hashMap);
        }
        this.checkSAXVersion(hashMap);
        this.checkSystemProperties(hashMap);
        return hashMap;
    }

    protected boolean writeEnvironmentReport(Map<String, Object> map) {
        if (null == map) {
            this.logMsg("# ERROR: writeEnvironmentReport called with null Map");
            return false;
        }
        boolean bl = false;
        this.logMsg("#---- BEGIN writeEnvironmentReport($Revision: 1.10 $): Useful stuff found: ----");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            try {
                if (string.startsWith(FOUNDCLASSES)) {
                    ArrayList arrayList = (ArrayList)entry.getValue();
                    bl |= this.logFoundJars(arrayList, string);
                    continue;
                }
                if (string.startsWith(ERROR)) {
                    bl = true;
                }
                this.logMsg(string + "=" + map.get(string));
            }
            catch (Exception exception) {
                this.logMsg("Reading-" + string + "= threw: " + exception.toString());
            }
        }
        this.logMsg("#----- END writeEnvironmentReport: Useful properties found: -----");
        return bl;
    }

    protected boolean logFoundJars(List<Map> list, String string) {
        if (null == list || list.size() < 1) {
            return false;
        }
        boolean bl = false;
        this.logMsg("#---- BEGIN Listing XML-related jars in: " + string + " ----");
        for (Map map : list) {
            for (Map.Entry entry : map.entrySet()) {
                String string2 = (String)entry.getKey();
                try {
                    if (string2.startsWith(ERROR)) {
                        bl = true;
                    }
                    this.logMsg(string2 + "=" + (String)entry.getValue());
                }
                catch (Exception exception) {
                    bl = true;
                    this.logMsg("Reading-" + string2 + "= threw: " + exception.toString());
                }
            }
        }
        this.logMsg("#----- END Listing XML-related jars in: " + string + " -----");
        return bl;
    }

    public void appendEnvironmentReport(Node node, Document document, Map<String, Object> map) {
        if (null == node || null == document) {
            return;
        }
        try {
            Element element = document.createElement("EnvironmentCheck");
            element.setAttribute("version", "$Revision: 1.10 $");
            node.appendChild(element);
            if (null == map) {
                Element element2 = document.createElement("status");
                element2.setAttribute("result", "ERROR");
                element2.appendChild(document.createTextNode("appendEnvironmentReport called with null Map!"));
                element.appendChild(element2);
                return;
            }
            boolean bl = false;
            Element element3 = document.createElement("environment");
            element.appendChild(element3);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String string = entry.getKey();
                try {
                    Object object;
                    if (string.startsWith(FOUNDCLASSES)) {
                        object = (List)entry.getValue();
                        bl |= this.appendFoundJars(element3, document, (List<Map>)object, string);
                        continue;
                    }
                    if (string.startsWith(ERROR)) {
                        bl = true;
                    }
                    object = document.createElement("item");
                    object.setAttribute("key", string);
                    object.appendChild(document.createTextNode((String)map.get(string)));
                    element3.appendChild((Node)object);
                }
                catch (Exception exception) {
                    bl = true;
                    Element element4 = document.createElement("item");
                    element4.setAttribute("key", string);
                    element4.appendChild(document.createTextNode("ERROR. Reading " + string + " threw: " + exception.toString()));
                    element3.appendChild(element4);
                }
            }
            Element element5 = document.createElement("status");
            element5.setAttribute("result", bl ? "ERROR" : "OK");
            element.appendChild(element5);
        }
        catch (Exception exception) {
            System.err.println("appendEnvironmentReport threw: " + exception.toString());
            exception.printStackTrace();
        }
    }

    protected boolean appendFoundJars(Node node, Document document, List<Map> list, String string) {
        if (null == list || list.size() < 1) {
            return false;
        }
        boolean bl = false;
        for (Map map : list) {
            for (Map.Entry entry : map.entrySet()) {
                String string2 = (String)entry.getKey();
                try {
                    if (string2.startsWith(ERROR)) {
                        bl = true;
                    }
                    Element element = document.createElement("foundJar");
                    element.setAttribute("name", string2.substring(0, string2.indexOf("-")));
                    element.setAttribute("desc", string2.substring(string2.indexOf("-") + 1));
                    element.appendChild(document.createTextNode((String)entry.getValue()));
                    node.appendChild(element);
                }
                catch (Exception exception) {
                    bl = true;
                    Element element = document.createElement("foundJar");
                    element.appendChild(document.createTextNode("ERROR. Reading " + string2 + " threw: " + exception.toString()));
                    node.appendChild(element);
                }
            }
        }
        return bl;
    }

    protected void checkSystemProperties(Map<String, Object> map) {
        String string;
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        try {
            string = SecuritySupport.getSystemProperty("java.version");
            map.put("java.version", string);
        }
        catch (SecurityException securityException) {
            map.put("java.version", "WARNING: SecurityException thrown accessing system version properties");
        }
        try {
            String string2;
            string = SecuritySupport.getSystemProperty("java.class.path");
            map.put("java.class.path", string);
            List<Map> list = this.checkPathForJars(string, this.jarNames);
            if (null != list) {
                map.put("foundclasses.java.class.path", list);
            }
            if (null != (string2 = SecuritySupport.getSystemProperty("sun.boot.class.path"))) {
                map.put("sun.boot.class.path", string2);
                list = this.checkPathForJars(string2, this.jarNames);
                if (null != list) {
                    map.put("foundclasses.sun.boot.class.path", list);
                }
            }
            if (null != (string2 = SecuritySupport.getSystemProperty("java.ext.dirs"))) {
                map.put("java.ext.dirs", string2);
                list = this.checkPathForJars(string2, this.jarNames);
                if (null != list) {
                    map.put("foundclasses.java.ext.dirs", list);
                }
            }
        }
        catch (SecurityException securityException) {
            map.put("java.class.path", "WARNING: SecurityException thrown accessing system classpath properties");
        }
    }

    protected List<Map> checkPathForJars(String string, String[] stringArray) {
        if (null == string || null == stringArray || 0 == string.length() || 0 == stringArray.length) {
            return null;
        }
        ArrayList<Map> arrayList = new ArrayList<Map>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            for (int i = 0; i < stringArray.length; ++i) {
                HashMap<String, String> hashMap;
                if (string2.indexOf(stringArray[i]) <= -1) continue;
                File file = new File(string2);
                if (file.exists()) {
                    try {
                        hashMap = new HashMap(2);
                        hashMap.put(stringArray[i] + "-path", file.getAbsolutePath());
                        if (!"xalan.jar".equalsIgnoreCase(stringArray[i])) {
                            hashMap.put(stringArray[i] + "-apparent.version", this.getApparentVersion(stringArray[i], file.length()));
                        }
                        arrayList.add(hashMap);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                hashMap = new HashMap<String, String>(2);
                hashMap.put(stringArray[i] + "-path", "WARNING. Classpath entry: " + string2 + " does not exist");
                hashMap.put(stringArray[i] + "-apparent.version", CLASS_NOTPRESENT);
                arrayList.add(hashMap);
            }
        }
        return arrayList;
    }

    protected String getApparentVersion(String string, long l) {
        String string2 = JARVERSIONS.get(new Long(l));
        if (null != string2 && string2.startsWith(string)) {
            return string2;
        }
        if ("xerces.jar".equalsIgnoreCase(string) || "xercesImpl.jar".equalsIgnoreCase(string)) {
            return string + " " + WARNING + CLASS_PRESENT;
        }
        return string + " " + CLASS_PRESENT;
    }

    protected void checkJAXPVersion(Map<String, Object> map) {
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        Class<?> clazz = null;
        try {
            String string = "javax.xml.stream.XMLStreamConstants";
            clazz = ObjectFactory.findProviderClass("javax.xml.stream.XMLStreamConstants", true);
            map.put("version.JAXP", "1.4");
        }
        catch (Exception exception) {
            map.put("ERROR.version.JAXP", "1.3");
            map.put(ERROR, ERROR_FOUND);
        }
    }

    protected void checkProcessorVersion(Map<String, Object> map) {
        AnnotatedElement annotatedElement;
        Class[] classArray;
        Object object;
        String string;
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        try {
            string = "com.sun.org.apache.xalan.internal.xslt.XSLProcessorVersion";
            object = ObjectFactory.findProviderClass("com.sun.org.apache.xalan.internal.xslt.XSLProcessorVersion", true);
            classArray = new StringBuffer();
            annotatedElement = ((Class)object).getField("PRODUCT");
            classArray.append(((Field)annotatedElement).get(null));
            classArray.append(';');
            annotatedElement = ((Class)object).getField("LANGUAGE");
            classArray.append(((Field)annotatedElement).get(null));
            classArray.append(';');
            annotatedElement = ((Class)object).getField("S_VERSION");
            classArray.append(((Field)annotatedElement).get(null));
            classArray.append(';');
            map.put("version.xalan1", classArray.toString());
        }
        catch (Exception exception) {
            map.put("version.xalan1", CLASS_NOTPRESENT);
        }
        try {
            string = "com.sun.org.apache.xalan.internal.processor.XSLProcessorVersion";
            object = ObjectFactory.findProviderClass("com.sun.org.apache.xalan.internal.processor.XSLProcessorVersion", true);
            classArray = new StringBuffer();
            annotatedElement = ((Class)object).getField("S_VERSION");
            classArray.append(((Field)annotatedElement).get(null));
            map.put("version.xalan2x", classArray.toString());
        }
        catch (Exception exception) {
            map.put("version.xalan2x", CLASS_NOTPRESENT);
        }
        try {
            string = "com.sun.org.apache.xalan.internal.Version";
            object = "getVersion";
            classArray = new Class[]{};
            annotatedElement = ObjectFactory.findProviderClass("com.sun.org.apache.xalan.internal.Version", true);
            Method method = ((Class)annotatedElement).getMethod("getVersion", classArray);
            Object object2 = method.invoke(null, new Object[0]);
            map.put("version.xalan2_2", (String)object2);
        }
        catch (Exception exception) {
            map.put("version.xalan2_2", CLASS_NOTPRESENT);
        }
    }

    protected void checkParserVersion(Map<String, Object> map) {
        String string;
        Field field;
        Class<?> clazz;
        String string2;
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        try {
            string2 = "com.sun.org.apache.xerces.internal.framework.Version";
            clazz = ObjectFactory.findProviderClass("com.sun.org.apache.xerces.internal.framework.Version", true);
            field = clazz.getField("fVersion");
            string = (String)field.get(null);
            map.put("version.xerces1", string);
        }
        catch (Exception exception) {
            map.put("version.xerces1", CLASS_NOTPRESENT);
        }
        try {
            string2 = "com.sun.org.apache.xerces.internal.impl.Version";
            clazz = ObjectFactory.findProviderClass("com.sun.org.apache.xerces.internal.impl.Version", true);
            field = clazz.getField("fVersion");
            string = (String)field.get(null);
            map.put("version.xerces2", string);
        }
        catch (Exception exception) {
            map.put("version.xerces2", CLASS_NOTPRESENT);
        }
        try {
            string2 = "org.apache.crimson.parser.Parser2";
            clazz = ObjectFactory.findProviderClass("org.apache.crimson.parser.Parser2", true);
            map.put("version.crimson", CLASS_PRESENT);
        }
        catch (Exception exception) {
            map.put("version.crimson", CLASS_NOTPRESENT);
        }
    }

    protected void checkAntVersion(Map<String, Object> map) {
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        try {
            String string = "org.apache.tools.ant.Main";
            String string2 = "getAntVersion";
            Class[] classArray = new Class[]{};
            Class<?> clazz = ObjectFactory.findProviderClass("org.apache.tools.ant.Main", true);
            Method method = clazz.getMethod("getAntVersion", classArray);
            Object object = method.invoke(null, new Object[0]);
            map.put("version.ant", (String)object);
        }
        catch (Exception exception) {
            map.put("version.ant", CLASS_NOTPRESENT);
        }
    }

    protected boolean checkDOML3(Map<String, Object> map) {
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        String string = "org.w3c.dom.Document";
        String string2 = "getDoctype";
        try {
            Class<?> clazz = ObjectFactory.findProviderClass("org.w3c.dom.Document", true);
            Method method = clazz.getMethod("getDoctype", null);
            map.put("version.DOM", "3.0");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void checkDOMVersion(Map<String, Object> map) {
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        String string = "org.w3c.dom.Document";
        String string2 = "createElementNS";
        String string3 = "getDoctype";
        String string4 = "org.w3c.dom.Node";
        String string5 = "supported";
        String string6 = "org.w3c.dom.Node";
        String string7 = "isSupported";
        Class[] classArray = new Class[]{String.class, String.class};
        try {
            Class<?> clazz = ObjectFactory.findProviderClass("org.w3c.dom.Document", true);
            Method method = clazz.getMethod("createElementNS", classArray);
            map.put("version.DOM", "2.0");
            try {
                clazz = ObjectFactory.findProviderClass("org.w3c.dom.Node", true);
                method = clazz.getMethod("supported", classArray);
                map.put("ERROR.version.DOM.draftlevel", "2.0wd");
                map.put(ERROR, ERROR_FOUND);
            }
            catch (Exception exception) {
                try {
                    clazz = ObjectFactory.findProviderClass("org.w3c.dom.Node", true);
                    method = clazz.getMethod("isSupported", classArray);
                    map.put("version.DOM.draftlevel", "2.0fd");
                }
                catch (Exception exception2) {
                    map.put("ERROR.version.DOM.draftlevel", "2.0unknown");
                    map.put(ERROR, ERROR_FOUND);
                }
            }
        }
        catch (Exception exception) {
            map.put("ERROR.version.DOM", "ERROR attempting to load DOM level 2 class: " + exception.toString());
            map.put(ERROR, ERROR_FOUND);
        }
    }

    protected void checkSAXVersion(Map<String, Object> map) {
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        String string = "org.xml.sax.Parser";
        String string2 = "parse";
        String string3 = "org.xml.sax.XMLReader";
        String string4 = "parse";
        String string5 = "org.xml.sax.helpers.AttributesImpl";
        String string6 = "setAttributes";
        Class[] classArray = new Class[]{String.class};
        Class[] classArray2 = new Class[]{Attributes.class};
        try {
            Class<?> clazz = ObjectFactory.findProviderClass("org.xml.sax.helpers.AttributesImpl", true);
            Method method = clazz.getMethod("setAttributes", classArray2);
            map.put("version.SAX", "2.0");
        }
        catch (Exception exception) {
            map.put("ERROR.version.SAX", "ERROR attempting to load SAX version 2 class: " + exception.toString());
            map.put(ERROR, ERROR_FOUND);
            try {
                Class<?> clazz = ObjectFactory.findProviderClass("org.xml.sax.XMLReader", true);
                Method method = clazz.getMethod("parse", classArray);
                map.put("version.SAX-backlevel", "2.0beta2-or-earlier");
            }
            catch (Exception exception2) {
                map.put("ERROR.version.SAX", "ERROR attempting to load SAX version 2 class: " + exception.toString());
                map.put(ERROR, ERROR_FOUND);
                try {
                    Class<?> clazz = ObjectFactory.findProviderClass("org.xml.sax.Parser", true);
                    Method method = clazz.getMethod("parse", classArray);
                    map.put("version.SAX-backlevel", "1.0");
                }
                catch (Exception exception3) {
                    map.put("ERROR.version.SAX-backlevel", "ERROR attempting to load SAX version 1 class: " + exception3.toString());
                }
            }
        }
    }

    protected void logMsg(String string) {
        this.outWriter.println(string);
    }

    static {
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        hashMap.put(new Long(857192L), "xalan.jar from xalan-j_1_1");
        hashMap.put(new Long(440237L), "xalan.jar from xalan-j_1_2");
        hashMap.put(new Long(436094L), "xalan.jar from xalan-j_1_2_1");
        hashMap.put(new Long(426249L), "xalan.jar from xalan-j_1_2_2");
        hashMap.put(new Long(702536L), "xalan.jar from xalan-j_2_0_0");
        hashMap.put(new Long(720930L), "xalan.jar from xalan-j_2_0_1");
        hashMap.put(new Long(732330L), "xalan.jar from xalan-j_2_1_0");
        hashMap.put(new Long(872241L), "xalan.jar from xalan-j_2_2_D10");
        hashMap.put(new Long(882739L), "xalan.jar from xalan-j_2_2_D11");
        hashMap.put(new Long(923866L), "xalan.jar from xalan-j_2_2_0");
        hashMap.put(new Long(905872L), "xalan.jar from xalan-j_2_3_D1");
        hashMap.put(new Long(906122L), "xalan.jar from xalan-j_2_3_0");
        hashMap.put(new Long(906248L), "xalan.jar from xalan-j_2_3_1");
        hashMap.put(new Long(983377L), "xalan.jar from xalan-j_2_4_D1");
        hashMap.put(new Long(997276L), "xalan.jar from xalan-j_2_4_0");
        hashMap.put(new Long(1031036L), "xalan.jar from xalan-j_2_4_1");
        hashMap.put(new Long(596540L), "xsltc.jar from xalan-j_2_2_0");
        hashMap.put(new Long(590247L), "xsltc.jar from xalan-j_2_3_D1");
        hashMap.put(new Long(589914L), "xsltc.jar from xalan-j_2_3_0");
        hashMap.put(new Long(589915L), "xsltc.jar from xalan-j_2_3_1");
        hashMap.put(new Long(1306667L), "xsltc.jar from xalan-j_2_4_D1");
        hashMap.put(new Long(1328227L), "xsltc.jar from xalan-j_2_4_0");
        hashMap.put(new Long(1344009L), "xsltc.jar from xalan-j_2_4_1");
        hashMap.put(new Long(1348361L), "xsltc.jar from xalan-j_2_5_D1");
        hashMap.put(new Long(1268634L), "xsltc.jar-bundled from xalan-j_2_3_0");
        hashMap.put(new Long(100196L), "xml-apis.jar from xalan-j_2_2_0 or xalan-j_2_3_D1");
        hashMap.put(new Long(108484L), "xml-apis.jar from xalan-j_2_3_0, or xalan-j_2_3_1 from xml-commons-1.0.b2");
        hashMap.put(new Long(109049L), "xml-apis.jar from xalan-j_2_4_0 from xml-commons RIVERCOURT1 branch");
        hashMap.put(new Long(113749L), "xml-apis.jar from xalan-j_2_4_1 from factoryfinder-build of xml-commons RIVERCOURT1");
        hashMap.put(new Long(124704L), "xml-apis.jar from tck-jaxp-1_2_0 branch of xml-commons");
        hashMap.put(new Long(124724L), "xml-apis.jar from tck-jaxp-1_2_0 branch of xml-commons, tag: xml-commons-external_1_2_01");
        hashMap.put(new Long(194205L), "xml-apis.jar from head branch of xml-commons, tag: xml-commons-external_1_3_02");
        hashMap.put(new Long(424490L), "xalan.jar from Xerces Tools releases - ERROR:DO NOT USE!");
        hashMap.put(new Long(1591855L), "xerces.jar from xalan-j_1_1 from xerces-1...");
        hashMap.put(new Long(1498679L), "xerces.jar from xalan-j_1_2 from xerces-1_2_0.bin");
        hashMap.put(new Long(1484896L), "xerces.jar from xalan-j_1_2_1 from xerces-1_2_1.bin");
        hashMap.put(new Long(804460L), "xerces.jar from xalan-j_1_2_2 from xerces-1_2_2.bin");
        hashMap.put(new Long(1499244L), "xerces.jar from xalan-j_2_0_0 from xerces-1_2_3.bin");
        hashMap.put(new Long(1605266L), "xerces.jar from xalan-j_2_0_1 from xerces-1_3_0.bin");
        hashMap.put(new Long(904030L), "xerces.jar from xalan-j_2_1_0 from xerces-1_4.bin");
        hashMap.put(new Long(904030L), "xerces.jar from xerces-1_4_0.bin");
        hashMap.put(new Long(1802885L), "xerces.jar from xerces-1_4_2.bin");
        hashMap.put(new Long(1734594L), "xerces.jar from Xerces-J-bin.2.0.0.beta3");
        hashMap.put(new Long(1808883L), "xerces.jar from xalan-j_2_2_D10,D11,D12 or xerces-1_4_3.bin");
        hashMap.put(new Long(1812019L), "xerces.jar from xalan-j_2_2_0");
        hashMap.put(new Long(1720292L), "xercesImpl.jar from xalan-j_2_3_D1");
        hashMap.put(new Long(1730053L), "xercesImpl.jar from xalan-j_2_3_0 or xalan-j_2_3_1 from xerces-2_0_0");
        hashMap.put(new Long(1728861L), "xercesImpl.jar from xalan-j_2_4_D1 from xerces-2_0_1");
        hashMap.put(new Long(972027L), "xercesImpl.jar from xalan-j_2_4_0 from xerces-2_1");
        hashMap.put(new Long(831587L), "xercesImpl.jar from xalan-j_2_4_1 from xerces-2_2");
        hashMap.put(new Long(891817L), "xercesImpl.jar from xalan-j_2_5_D1 from xerces-2_3");
        hashMap.put(new Long(895924L), "xercesImpl.jar from xerces-2_4");
        hashMap.put(new Long(1010806L), "xercesImpl.jar from Xerces-J-bin.2.6.2");
        hashMap.put(new Long(1203860L), "xercesImpl.jar from Xerces-J-bin.2.7.1");
        hashMap.put(new Long(37485L), "xalanj1compat.jar from xalan-j_2_0_0");
        hashMap.put(new Long(38100L), "xalanj1compat.jar from xalan-j_2_0_1");
        hashMap.put(new Long(18779L), "xalanservlet.jar from xalan-j_2_0_0");
        hashMap.put(new Long(21453L), "xalanservlet.jar from xalan-j_2_0_1");
        hashMap.put(new Long(24826L), "xalanservlet.jar from xalan-j_2_3_1 or xalan-j_2_4_1");
        hashMap.put(new Long(24831L), "xalanservlet.jar from xalan-j_2_4_1");
        hashMap.put(new Long(5618L), "jaxp.jar from jaxp1.0.1");
        hashMap.put(new Long(136133L), "parser.jar from jaxp1.0.1");
        hashMap.put(new Long(28404L), "jaxp.jar from jaxp-1.1");
        hashMap.put(new Long(187162L), "crimson.jar from jaxp-1.1");
        hashMap.put(new Long(801714L), "xalan.jar from jaxp-1.1");
        hashMap.put(new Long(196399L), "crimson.jar from crimson-1.1.1");
        hashMap.put(new Long(33323L), "jaxp.jar from crimson-1.1.1 or jakarta-ant-1.4.1b1");
        hashMap.put(new Long(152717L), "crimson.jar from crimson-1.1.2beta2");
        hashMap.put(new Long(88143L), "xml-apis.jar from crimson-1.1.2beta2");
        hashMap.put(new Long(206384L), "crimson.jar from crimson-1.1.3 or jakarta-ant-1.4.1b1");
        hashMap.put(new Long(136198L), "parser.jar from jakarta-ant-1.3 or 1.2");
        hashMap.put(new Long(5537L), "jaxp.jar from jakarta-ant-1.3 or 1.2");
        JARVERSIONS = Collections.unmodifiableMap(hashMap);
    }
}

