/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantDynamic;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantInvokeDynamic;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodHandle;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodType;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantModule;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPackage;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.BCELComparator;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;

public abstract class Constant
implements Cloneable,
Node {
    private static BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public boolean equals(Object object, Object object2) {
            Constant constant = (Constant)object;
            Constant constant2 = (Constant)object2;
            return Objects.equals(constant.toString(), constant2.toString());
        }

        @Override
        public int hashCode(Object object) {
            Constant constant = (Constant)object;
            return constant.toString().hashCode();
        }
    };
    private byte tag;

    Constant(byte by) {
        this.tag = by;
    }

    @Override
    public abstract void accept(Visitor var1);

    public abstract void dump(DataOutputStream var1) throws IOException;

    public final byte getTag() {
        return this.tag;
    }

    public String toString() {
        return Const.getConstantName(this.tag) + "[" + this.tag + "]";
    }

    public Constant copy() {
        try {
            return (Constant)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone Not Supported");
        }
    }

    public static Constant readConstant(DataInput dataInput) throws IOException, ClassFormatException {
        byte by = dataInput.readByte();
        switch (by) {
            case 7: {
                return new ConstantClass(dataInput);
            }
            case 9: {
                return new ConstantFieldref(dataInput);
            }
            case 10: {
                return new ConstantMethodref(dataInput);
            }
            case 11: {
                return new ConstantInterfaceMethodref(dataInput);
            }
            case 8: {
                return new ConstantString(dataInput);
            }
            case 3: {
                return new ConstantInteger(dataInput);
            }
            case 4: {
                return new ConstantFloat(dataInput);
            }
            case 5: {
                return new ConstantLong(dataInput);
            }
            case 6: {
                return new ConstantDouble(dataInput);
            }
            case 12: {
                return new ConstantNameAndType(dataInput);
            }
            case 1: {
                return ConstantUtf8.getInstance(dataInput);
            }
            case 15: {
                return new ConstantMethodHandle(dataInput);
            }
            case 16: {
                return new ConstantMethodType(dataInput);
            }
            case 17: {
                return new ConstantDynamic(dataInput);
            }
            case 18: {
                return new ConstantInvokeDynamic(dataInput);
            }
            case 19: {
                return new ConstantModule(dataInput);
            }
            case 20: {
                return new ConstantPackage(dataInput);
            }
        }
        throw new ClassFormatException("Invalid byte tag in constant pool: " + by);
    }

    public static BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(BCELComparator bCELComparator) {
        bcelComparator = bCELComparator;
    }

    public boolean equals(Object object) {
        return bcelComparator.equals(this, object);
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }
}

