/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.BootstrapMethod;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class BootstrapMethods
extends Attribute {
    private BootstrapMethod[] bootstrap_methods;

    public BootstrapMethods(BootstrapMethods bootstrapMethods) {
        this(bootstrapMethods.getNameIndex(), bootstrapMethods.getLength(), bootstrapMethods.getBootstrapMethods(), bootstrapMethods.getConstantPool());
    }

    public BootstrapMethods(int n, int n2, BootstrapMethod[] bootstrapMethodArray, ConstantPool constantPool) {
        super((byte)20, n, n2, constantPool);
        this.bootstrap_methods = bootstrapMethodArray;
    }

    BootstrapMethods(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (BootstrapMethod[])null, constantPool);
        int n3 = dataInput.readUnsignedShort();
        this.bootstrap_methods = new BootstrapMethod[n3];
        for (int i = 0; i < n3; ++i) {
            this.bootstrap_methods[i] = new BootstrapMethod(dataInput);
        }
    }

    public final BootstrapMethod[] getBootstrapMethods() {
        return this.bootstrap_methods;
    }

    public final void setBootstrapMethods(BootstrapMethod[] bootstrapMethodArray) {
        this.bootstrap_methods = bootstrapMethodArray;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitBootstrapMethods(this);
    }

    @Override
    public BootstrapMethods copy(ConstantPool constantPool) {
        BootstrapMethods bootstrapMethods = (BootstrapMethods)this.clone();
        bootstrapMethods.bootstrap_methods = new BootstrapMethod[this.bootstrap_methods.length];
        for (int i = 0; i < this.bootstrap_methods.length; ++i) {
            bootstrapMethods.bootstrap_methods[i] = this.bootstrap_methods[i].copy();
        }
        bootstrapMethods.setConstantPool(constantPool);
        return bootstrapMethods;
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.bootstrap_methods.length);
        for (BootstrapMethod bootstrapMethod : this.bootstrap_methods) {
            bootstrapMethod.dump(dataOutputStream);
        }
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BootstrapMethods(");
        stringBuilder.append(this.bootstrap_methods.length);
        stringBuilder.append("):\n");
        for (int i = 0; i < this.bootstrap_methods.length; ++i) {
            stringBuilder.append("  ").append(i).append(": ");
            stringBuilder.append(this.bootstrap_methods[i].toString(super.getConstantPool())).append("\n");
        }
        return stringBuilder.toString();
    }
}

